/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.formatter.internal;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.ast.AutoLink;
import icyllis.flexmark.ast.BlockQuote;
import icyllis.flexmark.ast.BulletList;
import icyllis.flexmark.ast.BulletListItem;
import icyllis.flexmark.ast.Code;
import icyllis.flexmark.ast.DelimitedLinkNode;
import icyllis.flexmark.ast.Emphasis;
import icyllis.flexmark.ast.FencedCodeBlock;
import icyllis.flexmark.ast.HardLineBreak;
import icyllis.flexmark.ast.Heading;
import icyllis.flexmark.ast.HtmlBlock;
import icyllis.flexmark.ast.HtmlBlockBase;
import icyllis.flexmark.ast.HtmlCommentBlock;
import icyllis.flexmark.ast.HtmlEntity;
import icyllis.flexmark.ast.HtmlInline;
import icyllis.flexmark.ast.HtmlInlineComment;
import icyllis.flexmark.ast.HtmlInnerBlock;
import icyllis.flexmark.ast.HtmlInnerBlockComment;
import icyllis.flexmark.ast.Image;
import icyllis.flexmark.ast.ImageRef;
import icyllis.flexmark.ast.IndentedCodeBlock;
import icyllis.flexmark.ast.Link;
import icyllis.flexmark.ast.LinkRef;
import icyllis.flexmark.ast.ListBlock;
import icyllis.flexmark.ast.ListItem;
import icyllis.flexmark.ast.MailLink;
import icyllis.flexmark.ast.OrderedList;
import icyllis.flexmark.ast.OrderedListItem;
import icyllis.flexmark.ast.Paragraph;
import icyllis.flexmark.ast.ParagraphContainer;
import icyllis.flexmark.ast.ParagraphItemContainer;
import icyllis.flexmark.ast.RefNode;
import icyllis.flexmark.ast.Reference;
import icyllis.flexmark.ast.SoftLineBreak;
import icyllis.flexmark.ast.StrongEmphasis;
import icyllis.flexmark.ast.Text;
import icyllis.flexmark.ast.TextBase;
import icyllis.flexmark.ast.ThematicBreak;
import icyllis.flexmark.ast.util.ReferenceRepository;
import icyllis.flexmark.formatter.Formatter;
import icyllis.flexmark.formatter.FormatterOptions;
import icyllis.flexmark.formatter.FormatterUtils;
import icyllis.flexmark.formatter.FormattingPhase;
import icyllis.flexmark.formatter.MarkdownWriter;
import icyllis.flexmark.formatter.NodeFormatter;
import icyllis.flexmark.formatter.NodeFormatterContext;
import icyllis.flexmark.formatter.NodeFormatterFactory;
import icyllis.flexmark.formatter.NodeFormattingHandler;
import icyllis.flexmark.formatter.NodeRepositoryFormatter;
import icyllis.flexmark.formatter.RenderPurpose;
import icyllis.flexmark.formatter.TranslationPlaceholderGenerator;
import icyllis.flexmark.html.renderer.HtmlIdGenerator;
import icyllis.flexmark.html.renderer.LinkType;
import icyllis.flexmark.html.renderer.ResolvedLink;
import icyllis.flexmark.parser.ListOptions;
import icyllis.flexmark.parser.Parser;
import icyllis.flexmark.parser.ParserEmulationProfile;
import icyllis.flexmark.util.ast.BlankLine;
import icyllis.flexmark.util.ast.Block;
import icyllis.flexmark.util.ast.Document;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.ast.NodeRepository;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.data.DataKey;
import icyllis.flexmark.util.data.DataKeyBase;
import icyllis.flexmark.util.data.MutableDataHolder;
import icyllis.flexmark.util.data.NotNullValueSupplier;
import icyllis.flexmark.util.format.options.DiscretionaryText;
import icyllis.flexmark.util.format.options.ElementPlacement;
import icyllis.flexmark.util.format.options.ElementPlacementSort;
import icyllis.flexmark.util.format.options.HeadingStyle;
import icyllis.flexmark.util.format.options.ListSpacing;
import icyllis.flexmark.util.misc.CharPredicate;
import icyllis.flexmark.util.misc.Utils;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.RepeatedSequence;
import icyllis.flexmark.util.sequence.mappers.SpaceMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CoreNodeFormatter
extends NodeRepositoryFormatter<ReferenceRepository, Reference, RefNode> {
    @Deprecated
    public static final DataKey<Map<String, String>> UNIQUIFICATION_MAP = Formatter.UNIQUIFICATION_MAP;
    @Deprecated
    public static final DataKey<Map<String, String>> ATTRIBUTE_UNIQUIFICATION_ID_MAP = Formatter.ATTRIBUTE_UNIQUIFICATION_ID_MAP;
    final FormatterOptions formatterOptions;
    private final ListOptions listOptions;
    private final String myHtmlBlockPrefix;
    private final String myHtmlInlinePrefix;
    private final String myTranslationAutolinkPrefix;
    private int blankLines;
    MutableDataHolder myTranslationStore;
    private Map<String, String> attributeUniquificationIdMap;
    static final TranslationPlaceholderGenerator htmlEntityPlaceholderGenerator = index -> String.format(Locale.US, "&#%d;", index);
    public static final DataKey<Boolean> UNWRAPPED_AUTO_LINKS = new DataKey<Boolean>("UNWRAPPED_AUTO_LINKS", false);
    public static final DataKey<HashSet<String>> UNWRAPPED_AUTO_LINKS_MAP = new DataKey<NotNullValueSupplier<HashSet>>("UNWRAPPED_AUTO_LINKS_MAP", HashSet::new);

    public CoreNodeFormatter(DataHolder options) {
        super(options, null, Formatter.UNIQUIFICATION_MAP);
        this.formatterOptions = new FormatterOptions(options);
        this.listOptions = ListOptions.get(options);
        this.blankLines = 0;
        this.myHtmlBlockPrefix = "<" + this.formatterOptions.translationHtmlBlockPrefix;
        this.myHtmlInlinePrefix = this.formatterOptions.translationHtmlInlinePrefix;
        this.myTranslationAutolinkPrefix = this.formatterOptions.translationAutolinkPrefix;
    }

    @Override
    public char getBlockQuoteLikePrefixChar() {
        return '>';
    }

    @Override
    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<Node>(Node.class, this::render), new NodeFormattingHandler<AutoLink>(AutoLink.class, this::render), new NodeFormattingHandler<BlankLine>(BlankLine.class, this::render), new NodeFormattingHandler<BlockQuote>(BlockQuote.class, this::render), new NodeFormattingHandler<Code>(Code.class, this::render), new NodeFormattingHandler<Document>(Document.class, this::render), new NodeFormattingHandler<Emphasis>(Emphasis.class, this::render), new NodeFormattingHandler<FencedCodeBlock>(FencedCodeBlock.class, this::render), new NodeFormattingHandler<HardLineBreak>(HardLineBreak.class, this::render), new NodeFormattingHandler<Heading>(Heading.class, this::render), new NodeFormattingHandler<HtmlBlock>(HtmlBlock.class, this::render), new NodeFormattingHandler<HtmlCommentBlock>(HtmlCommentBlock.class, this::render), new NodeFormattingHandler<HtmlInnerBlock>(HtmlInnerBlock.class, this::render), new NodeFormattingHandler<HtmlInnerBlockComment>(HtmlInnerBlockComment.class, this::render), new NodeFormattingHandler<HtmlEntity>(HtmlEntity.class, this::render), new NodeFormattingHandler<HtmlInline>(HtmlInline.class, this::render), new NodeFormattingHandler<HtmlInlineComment>(HtmlInlineComment.class, this::render), new NodeFormattingHandler<Image>(Image.class, this::render), new NodeFormattingHandler<ImageRef>(ImageRef.class, this::render), new NodeFormattingHandler<IndentedCodeBlock>(IndentedCodeBlock.class, this::render), new NodeFormattingHandler<Link>(Link.class, this::render), new NodeFormattingHandler<LinkRef>(LinkRef.class, this::render), new NodeFormattingHandler<BulletList>(BulletList.class, this::render), new NodeFormattingHandler<OrderedList>(OrderedList.class, this::render), new NodeFormattingHandler<BulletListItem>(BulletListItem.class, this::render), new NodeFormattingHandler<OrderedListItem>(OrderedListItem.class, this::render), new NodeFormattingHandler<MailLink>(MailLink.class, this::render), new NodeFormattingHandler<Paragraph>(Paragraph.class, this::render), new NodeFormattingHandler<Reference>(Reference.class, this::render), new NodeFormattingHandler<SoftLineBreak>(SoftLineBreak.class, this::render), new NodeFormattingHandler<StrongEmphasis>(StrongEmphasis.class, this::render), new NodeFormattingHandler<Text>(Text.class, this::render), new NodeFormattingHandler<TextBase>(TextBase.class, this::render), new NodeFormattingHandler<ThematicBreak>(ThematicBreak.class, this::render)));
    }

    @Override
    @Nullable
    public Set<Class<?>> getNodeClasses() {
        if (this.formatterOptions.referencePlacement.isNoChange() || !this.formatterOptions.referenceSort.isUnused()) {
            return null;
        }
        return new HashSet(Arrays.asList(RefNode.class));
    }

    @Override
    public ReferenceRepository getRepository(DataHolder options) {
        return Parser.REFERENCES.get(options);
    }

    @Override
    public ElementPlacement getReferencePlacement() {
        return this.formatterOptions.referencePlacement;
    }

    @Override
    public ElementPlacementSort getReferenceSort() {
        return this.formatterOptions.referenceSort;
    }

    void appendReference(CharSequence id, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText() && context.getRenderPurpose() == RenderPurpose.TRANSLATED && context.getMergeContext() != null) {
            String reference = String.valueOf(context.transformTranslating(null, id, null, null));
            String uniquifiedReference = this.referenceUniqificationMap.getOrDefault(reference, reference);
            markdown.append(uniquifiedReference);
        } else {
            markdown.appendTranslating(id);
        }
    }

    @Override
    public void renderReferenceBlock(Reference node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            markdown.append(node.getOpeningMarker());
            this.appendReference(node.getReference(), context, markdown);
            markdown.append(node.getClosingMarker());
            markdown.append(' ');
            markdown.append(node.getUrlOpeningMarker());
            if (context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS) {
                ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl(), false);
                markdown.appendNonTranslating(resolvedLink.getPageRef());
                if (resolvedLink.getAnchorRef() != null) {
                    markdown.append("#");
                    CharSequence anchorRef = context.transformAnchorRef(resolvedLink.getPageRef(), resolvedLink.getAnchorRef());
                    if (this.attributeUniquificationIdMap != null && resolvedLink.getPageRef().isEmpty() && context.isTransformingText() && context.getMergeContext() != null) {
                        String stringAnchorRef = String.valueOf(anchorRef);
                        String uniquifiedAnchorRef = this.attributeUniquificationIdMap.getOrDefault(stringAnchorRef, stringAnchorRef);
                        markdown.append(uniquifiedAnchorRef);
                    } else {
                        markdown.append(anchorRef);
                    }
                    markdown.append(anchorRef);
                }
            } else {
                markdown.appendNonTranslating(node.getPageRef());
                markdown.append(node.getAnchorMarker());
                if (node.getAnchorRef().isNotNull()) {
                    CharSequence anchorRef = context.transformAnchorRef(node.getPageRef(), node.getAnchorRef());
                    markdown.append(anchorRef);
                }
            }
            if (node.getTitleOpeningMarker().isNotNull()) {
                markdown.append(' ');
                markdown.append(node.getTitleOpeningMarker());
                if (node.getTitle().isNotNull()) {
                    markdown.appendTranslating(node.getTitle());
                }
                markdown.append(node.getTitleClosingMarker());
            }
            ((MarkdownWriter)markdown.append(node.getUrlClosingMarker())).line();
        } else {
            ((MarkdownWriter)markdown.append(node.getChars())).line();
            Node next = node.getNext();
            if (next instanceof HtmlCommentBlock || next instanceof HtmlInnerBlockComment) {
                BasedSequence text = (BasedSequence)((BasedSequence)next.getChars().trim()).midSequence(4, -3);
                if (this.formatterOptions.linkMarkerCommentPattern != null && this.formatterOptions.linkMarkerCommentPattern.matcher(text).matches()) {
                    ((MarkdownWriter)((MarkdownWriter)markdown.append("<!--")).append(String.valueOf(text))).append("-->");
                }
            }
            markdown.line();
        }
    }

    @Override
    public void renderDocument(@NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown, @NotNull Document document, @NotNull FormattingPhase phase) {
        super.renderDocument(context, markdown, document, phase);
        this.attributeUniquificationIdMap = Formatter.ATTRIBUTE_UNIQUIFICATION_ID_MAP.get(context.getTranslationStore());
        if (phase == FormattingPhase.DOCUMENT_BOTTOM && this.formatterOptions.appendTransferredReferences) {
            ArrayList<DataKeyBase> keys = new ArrayList<DataKeyBase>();
            for (DataKeyBase<?> key : document.getAll().keySet()) {
                if (!(key.get(document) instanceof NodeRepository)) continue;
                keys.add(key);
            }
            keys.sort(Comparator.comparing(DataKeyBase::getName));
            boolean firstAppend = true;
            for (DataKeyBase key : keys) {
                if (!(key.get(document) instanceof NodeRepository)) continue;
                NodeRepository repository = (NodeRepository)key.get(document);
                Set nodes = repository.getReferencedElements(document);
                for (Object value : nodes) {
                    Node node;
                    if (!(value instanceof Node) || (node = (Node)value).getDocument() == document) continue;
                    if (firstAppend) {
                        firstAppend = false;
                        markdown.blankLine();
                    }
                    context.render(node);
                }
            }
        }
    }

    private void render(Node node, NodeFormatterContext context, MarkdownWriter markdown) {
        BasedSequence chars = node.getChars();
        if (node instanceof Block) {
            BasedSequence suffix;
            BasedSequence prefix;
            BasedSequence contentChars = ((Block)node).getContentChars();
            if (chars.isNotNull() && !(prefix = chars.prefixOf(contentChars)).isEmpty()) {
                markdown.append(prefix);
            }
            context.renderChildren(node);
            if (chars.isNotNull() && !(suffix = chars.suffixOf(contentChars)).isEmpty()) {
                markdown.append(suffix);
            }
        } else if (this.formatterOptions.keepSoftLineBreaks) {
            markdown.append(chars);
        } else {
            markdown.append(FormatterUtils.stripSoftLineBreak(chars, " "));
        }
    }

    private void render(BlankLine node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (FormatterUtils.LIST_ITEM_SPACING.get(context.getDocument()) == null && markdown.offsetWithPending() > 0) {
            if (node.getPrevious() != null && !(node.getPrevious() instanceof BlankLine)) {
                this.blankLines = 0;
            }
            ++this.blankLines;
            if (this.blankLines <= this.formatterOptions.maxBlankLines) {
                markdown.blankLine(this.blankLines);
            }
        }
    }

    private void render(Document node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTranslationStore = context.getTranslationStore();
        context.renderChildren(node);
    }

    private void render(Heading node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        HeadingStyle headingPreference = this.formatterOptions.headingStyle;
        if (context.isTransformingText() || headingPreference.isNoChange(node.isSetextHeading(), node.getLevel())) {
            if (node.isAtxHeading()) {
                boolean spaceAfterAtx;
                markdown.append(node.getOpeningMarker());
                boolean bl = spaceAfterAtx = this.formatterOptions.spaceAfterAtxMarker == DiscretionaryText.ADD || this.formatterOptions.spaceAfterAtxMarker == DiscretionaryText.AS_IS && node.getOpeningMarker().getEndOffset() < node.getText().getStartOffset();
                if (spaceAfterAtx) {
                    markdown.append(' ');
                }
                context.translatingRefTargetSpan(node, (context12, writer) -> context12.renderChildren(node));
                switch (this.formatterOptions.atxHeadingTrailingMarker) {
                    case EQUALIZE: {
                        if (node.getClosingMarker().isNull()) break;
                    }
                    case ADD: {
                        if (spaceAfterAtx) {
                            markdown.append(' ');
                        }
                        markdown.append(node.getOpeningMarker());
                        break;
                    }
                    case REMOVE: {
                        break;
                    }
                    default: {
                        if (!node.getClosingMarker().isNotNull()) break;
                        if (spaceAfterAtx) {
                            markdown.append(' ');
                        }
                        markdown.append(node.getClosingMarker());
                    }
                }
                HtmlIdGenerator generator = context.getIdGenerator();
                if (generator != null) {
                    context.addExplicitId(node, generator.getId(node), context, markdown);
                }
            } else {
                context.translatingRefTargetSpan(node, (context1, writer) -> context1.renderChildren(node));
                HtmlIdGenerator generator = context.getIdGenerator();
                if (generator != null) {
                    context.addExplicitId(node, generator.getId(node), context, markdown);
                }
                markdown.line();
                if (this.formatterOptions.setextHeadingEqualizeMarker) {
                    markdown.append(node.getClosingMarker().charAt(0), Utils.minLimit(markdown.getLineInfo((int)(markdown.getLineCountWithPending() - 1)).textLength, this.formatterOptions.minSetextMarkerLength));
                } else {
                    markdown.append(node.getClosingMarker());
                }
            }
        } else if (headingPreference.isSetext()) {
            char closingMarker;
            context.renderChildren(node);
            markdown.line();
            char c = closingMarker = node.getLevel() == 1 ? (char)'=' : '-';
            if (this.formatterOptions.setextHeadingEqualizeMarker) {
                markdown.append(closingMarker, Utils.minLimit(markdown.getLineInfo((int)(markdown.getLineCountWithPending() - 1)).textLength, this.formatterOptions.minSetextMarkerLength));
            } else {
                markdown.append(RepeatedSequence.repeatOf(closingMarker, this.formatterOptions.minSetextMarkerLength));
            }
        } else {
            boolean spaceAfterAtx;
            assert (headingPreference.isAtx());
            CharSequence openingMarker = RepeatedSequence.repeatOf('#', node.getLevel());
            markdown.append(openingMarker);
            boolean bl = spaceAfterAtx = this.formatterOptions.spaceAfterAtxMarker == DiscretionaryText.ADD || this.formatterOptions.spaceAfterAtxMarker == DiscretionaryText.AS_IS && Parser.HEADING_NO_ATX_SPACE.get(context.getOptions()) == false;
            if (spaceAfterAtx) {
                markdown.append(' ');
            }
            context.renderChildren(node);
            switch (this.formatterOptions.atxHeadingTrailingMarker) {
                case EQUALIZE: 
                case ADD: {
                    if (spaceAfterAtx) {
                        markdown.append(' ');
                    }
                    markdown.append(openingMarker);
                    break;
                }
            }
        }
        markdown.tailBlankLine();
    }

    private void render(BlockQuote node, NodeFormatterContext context, MarkdownWriter markdown) {
        FormatterUtils.renderBlockQuoteLike(node, context, markdown);
    }

    private void render(ThematicBreak node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        if (this.formatterOptions.thematicBreak != null) {
            markdown.append(this.formatterOptions.thematicBreak);
        } else {
            markdown.append(node.getChars());
        }
        markdown.tailBlankLine();
    }

    private void render(FencedCodeBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        CharSequence openingMarker = node.getOpeningMarker();
        CharSequence closingMarker = node.getClosingMarker();
        char openingMarkerChar = openingMarker.charAt(0);
        char closingMarkerChar = closingMarker.length() > 0 ? closingMarker.charAt(0) : (char)'\u0000';
        int openingMarkerLen = openingMarker.length();
        int closingMarkerLen = closingMarker.length();
        switch (this.formatterOptions.fencedCodeMarkerType) {
            case ANY: {
                break;
            }
            case BACK_TICK: {
                closingMarkerChar = openingMarkerChar = '`';
                break;
            }
            case TILDE: {
                closingMarkerChar = openingMarkerChar = '~';
            }
        }
        if (openingMarkerLen < this.formatterOptions.fencedCodeMarkerLength) {
            openingMarkerLen = this.formatterOptions.fencedCodeMarkerLength;
        }
        if (closingMarkerLen < this.formatterOptions.fencedCodeMarkerLength) {
            closingMarkerLen = this.formatterOptions.fencedCodeMarkerLength;
        }
        openingMarker = RepeatedSequence.repeatOf(String.valueOf(openingMarkerChar), openingMarkerLen);
        closingMarker = this.formatterOptions.fencedCodeMatchClosingMarker || closingMarkerChar == '\u0000' ? openingMarker : RepeatedSequence.repeatOf(String.valueOf(closingMarkerChar), closingMarkerLen);
        markdown.append(openingMarker);
        if (this.formatterOptions.fencedCodeSpaceBeforeInfo) {
            markdown.append(' ');
        }
        markdown.appendNonTranslating(node.getInfo());
        markdown.line();
        markdown.openPreFormatted(true);
        if (context.isTransformingText()) {
            markdown.appendNonTranslating(node.getContentChars());
        } else if (this.formatterOptions.fencedCodeMinimizeIndent) {
            List<BasedSequence> lines = node.getContentLines();
            int[] leadColumns = new int[lines.size()];
            int minSpaces = Integer.MAX_VALUE;
            int i = 0;
            for (BasedSequence line : lines) {
                leadColumns[i] = line.countLeadingColumns(0, CharPredicate.SPACE_TAB);
                minSpaces = Utils.min(minSpaces, leadColumns[i]);
                ++i;
            }
            if (minSpaces > 0) {
                i = 0;
                for (BasedSequence line : lines) {
                    if (leadColumns[i] > minSpaces) {
                        markdown.append(' ', leadColumns[i] - minSpaces);
                    }
                    markdown.append((CharSequence)line.trimStart());
                    ++i;
                }
            } else {
                markdown.append(node.getContentChars());
            }
        } else {
            markdown.append(node.getContentChars());
        }
        markdown.closePreFormatted();
        ((MarkdownWriter)((MarkdownWriter)markdown.line()).append(closingMarker)).line();
        if (!(node.getParent() instanceof ListItem) || !FormatterUtils.isLastOfItem(node) || FormatterUtils.LIST_ITEM_SPACING.get(context.getDocument()) == ListSpacing.LOOSE) {
            markdown.tailBlankLine();
        }
    }

    private void render(IndentedCodeBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        if (context.isTransformingText()) {
            BasedSequence contentChars = node.getContentChars();
            String prefix = FormatterUtils.getActualAdditionalPrefix(contentChars, markdown);
            if (context.getRenderPurpose() == RenderPurpose.TRANSLATED) {
                contentChars = (BasedSequence)contentChars.trimStart();
            }
            ((MarkdownWriter)markdown.pushPrefix()).addPrefix(prefix);
            markdown.openPreFormatted(true);
            markdown.appendNonTranslating(Utils.suffixWith(contentChars.toString(), '\n'));
        } else {
            String prefix = RepeatedSequence.repeatOf(" ", this.listOptions.getCodeIndent()).toString();
            if (this.formatterOptions.emulationProfile == ParserEmulationProfile.GITHUB_DOC && node.getParent() instanceof ListItem) {
                BasedSequence marker = ((ListItem)node.getParent()).getOpeningMarker();
                prefix = RepeatedSequence.repeatOf(" ", Utils.minLimit(8 - marker.length() - 1, 4)).toString();
            }
            ((MarkdownWriter)markdown.pushPrefix()).addPrefix(prefix);
            markdown.openPreFormatted(true);
            if (this.formatterOptions.indentedCodeMinimizeIndent) {
                List<BasedSequence> lines = node.getContentLines();
                int[] leadColumns = new int[lines.size()];
                int minSpaces = Integer.MAX_VALUE;
                int i = 0;
                for (BasedSequence line : lines) {
                    leadColumns[i] = line.countLeadingColumns(0, CharPredicate.SPACE_TAB);
                    minSpaces = Utils.min(minSpaces, leadColumns[i]);
                    ++i;
                }
                if (minSpaces > 0) {
                    i = 0;
                    for (BasedSequence line : lines) {
                        if (leadColumns[i] > minSpaces) {
                            markdown.append(' ', leadColumns[i] - minSpaces);
                        }
                        markdown.append((CharSequence)line.trimStart());
                        ++i;
                    }
                } else {
                    markdown.append(node.getContentChars());
                }
            } else {
                markdown.append(node.getContentChars());
            }
        }
        markdown.closePreFormatted();
        markdown.popPrefix(true);
        markdown.tailBlankLine();
    }

    private void render(BulletList node, NodeFormatterContext context, MarkdownWriter markdown) {
        FormatterUtils.renderList(node, context, markdown);
    }

    private void render(OrderedList node, NodeFormatterContext context, MarkdownWriter markdown) {
        FormatterUtils.renderList(node, context, markdown);
    }

    private void render(BulletListItem node, NodeFormatterContext context, MarkdownWriter markdown) {
        FormatterUtils.renderListItem(node, context, markdown, this.listOptions, node.getMarkerSuffix(), false);
    }

    private void render(OrderedListItem node, NodeFormatterContext context, MarkdownWriter markdown) {
        FormatterUtils.renderListItem(node, context, markdown, this.listOptions, node.getMarkerSuffix(), false);
    }

    private void render(Emphasis node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append(node.getOpeningMarker());
        context.renderChildren(node);
        markdown.append(node.getOpeningMarker());
    }

    private void render(StrongEmphasis node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append(node.getOpeningMarker());
        context.renderChildren(node);
        markdown.append(node.getOpeningMarker());
    }

    private void render(Paragraph node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.isTransformingText()) {
            FormatterUtils.renderTextBlockParagraphLines(node, context, markdown);
            if (node.isTrailingBlankLine()) {
                markdown.tailBlankLine();
            }
        } else if (!(node.getParent() instanceof ParagraphItemContainer)) {
            if (node.getParent() instanceof ParagraphContainer) {
                boolean startWrappingDisabled = ((ParagraphContainer)((Object)node.getParent())).isParagraphStartWrappingDisabled(node);
                boolean endWrappingDisabled = ((ParagraphContainer)((Object)node.getParent())).isParagraphEndWrappingDisabled(node);
                if (startWrappingDisabled || endWrappingDisabled) {
                    if (!startWrappingDisabled) {
                        markdown.blankLine();
                    }
                    FormatterUtils.renderTextBlockParagraphLines(node, context, markdown);
                    if (!endWrappingDisabled) {
                        markdown.tailBlankLine();
                    }
                } else {
                    FormatterUtils.renderLooseParagraph(node, context, markdown);
                }
            } else if (!node.isTrailingBlankLine() && (node.getNext() == null || node.getNext() instanceof ListBlock)) {
                FormatterUtils.renderTextBlockParagraphLines(node, context, markdown);
            } else {
                FormatterUtils.renderLooseParagraph(node, context, markdown);
            }
        } else {
            boolean isItemParagraph = ((ParagraphItemContainer)((Object)node.getParent())).isItemParagraph(node);
            if (isItemParagraph) {
                if (this.formatterOptions.blankLinesInAst) {
                    FormatterUtils.renderLooseItemParagraph(node, context, markdown);
                } else {
                    ListSpacing itemSpacing = FormatterUtils.LIST_ITEM_SPACING.get(context.getDocument());
                    if (itemSpacing == ListSpacing.TIGHT) {
                        FormatterUtils.renderTextBlockParagraphLines(node, context, markdown);
                    } else if (itemSpacing == ListSpacing.LOOSE) {
                        if (node.getParent().getNextAnyNot(BlankLine.class) == null) {
                            FormatterUtils.renderTextBlockParagraphLines(node, context, markdown);
                        } else {
                            FormatterUtils.renderLooseItemParagraph(node, context, markdown);
                        }
                    } else if (!((ParagraphItemContainer)((Object)node.getParent())).isParagraphWrappingDisabled(node, this.listOptions, context.getOptions())) {
                        FormatterUtils.renderLooseItemParagraph(node, context, markdown);
                    } else {
                        FormatterUtils.renderTextBlockParagraphLines(node, context, markdown);
                    }
                }
            } else {
                FormatterUtils.renderLooseParagraph(node, context, markdown);
            }
        }
    }

    private void render(SoftLineBreak node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (this.formatterOptions.keepSoftLineBreaks || this.formatterOptions.rightMargin > 0) {
            markdown.append(node.getChars());
        } else if (!markdown.isPendingSpace()) {
            markdown.append(' ');
        }
    }

    private void render(HardLineBreak node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (this.formatterOptions.keepHardLineBreaks) {
            if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
                markdown.append(node.getChars());
            } else {
                markdown.append(node.getChars());
            }
        } else if (!markdown.isPendingSpace()) {
            markdown.append(' ');
        }
    }

    private void render(HtmlEntity node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            markdown.append(node.getChars());
        } else {
            context.customPlaceholderFormat(htmlEntityPlaceholderGenerator, (context1, markdown1) -> markdown1.appendNonTranslating(node.getChars()));
        }
    }

    private void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (this.formatterOptions.keepSoftLineBreaks) {
            markdown.append(node.getChars());
        } else {
            markdown.append(FormatterUtils.stripSoftLineBreak(node.getChars(), " "));
        }
    }

    private void render(TextBase node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren(node);
    }

    private void render(Code node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append(node.getOpeningMarker());
        if (context.isTransformingText() || this.formatterOptions.rightMargin == 0) {
            if (this.formatterOptions.keepSoftLineBreaks) {
                markdown.appendNonTranslating(node.getText());
            } else {
                markdown.appendNonTranslating(FormatterUtils.stripSoftLineBreak(node.getText(), " "));
            }
        } else if (this.formatterOptions.keepSoftLineBreaks) {
            markdown.append(node.getText());
        } else {
            markdown.append(FormatterUtils.stripSoftLineBreak(node.getText(), " "));
        }
        markdown.append(node.getClosingMarker());
    }

    private void render(HtmlBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (node.hasChildren()) {
            context.renderChildren(node);
        } else {
            markdown.blankLine();
            this.render((HtmlBlockBase)node, context, markdown);
            markdown.tailBlankLine();
        }
    }

    private void render(HtmlCommentBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        BasedSequence text = (BasedSequence)((BasedSequence)node.getChars().trim()).midSequence(4, -3);
        BasedSequence trimmedEOL = BasedSequence.EOL;
        if (!context.isTransformingText() && this.formatterOptions.linkMarkerCommentPattern != null && this.formatterOptions.linkMarkerCommentPattern.matcher(text).matches()) {
            if (!(node.getPrevious() instanceof Reference)) {
                ((MarkdownWriter)((MarkdownWriter)markdown.append("<!--")).append(String.valueOf(text.toMapped(SpaceMapper.toNonBreakSpace)))).append("-->");
            }
        } else {
            markdown.appendTranslating("<!--", text, "-->", trimmedEOL);
        }
    }

    private void render(HtmlBlockBase node, NodeFormatterContext context, MarkdownWriter markdown) {
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: 
            case TRANSLATED_SPANS: {
                markdown.appendNonTranslating(this.myHtmlBlockPrefix, (CharSequence)node.getChars().trimEOL(), ">", (CharSequence)node.getChars().trimmedEOL());
                break;
            }
            case TRANSLATED: {
                markdown.openPreFormatted(true);
                markdown.appendNonTranslating(node.getChars());
                markdown.closePreFormatted();
                break;
            }
            default: {
                markdown.openPreFormatted(true);
                BasedSequence spanningChars = node.getSpanningChars();
                if (spanningChars.equals(node.getChars())) {
                    for (BasedSequence line : node.getContentLines()) {
                        markdown.append(line);
                    }
                } else {
                    markdown.append(node.getChars());
                }
                ((MarkdownWriter)markdown.line()).closePreFormatted();
            }
        }
    }

    private void render(HtmlInnerBlockComment node, NodeFormatterContext context, MarkdownWriter markdown) {
        BasedSequence text = (BasedSequence)((BasedSequence)node.getChars().trim()).midSequence(4, -3);
        if (!context.isTransformingText() && this.formatterOptions.linkMarkerCommentPattern != null && this.formatterOptions.linkMarkerCommentPattern.matcher(text).matches()) {
            if (!(node.getPrevious() instanceof Reference)) {
                ((MarkdownWriter)((MarkdownWriter)markdown.append("<!--")).append(String.valueOf(text.toMapped(SpaceMapper.toNonBreakSpace)))).append("-->");
            }
        } else {
            markdown.appendTranslating("<!--", text, "-->");
        }
    }

    private void render(HtmlInline node, NodeFormatterContext context, MarkdownWriter markdown) {
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: 
            case TRANSLATED_SPANS: {
                String prefix = node.getChars().startsWith("</") ? "</" : "<";
                markdown.appendNonTranslating(prefix + this.myHtmlInlinePrefix, node.getChars(), ">");
                break;
            }
            case TRANSLATED: {
                markdown.appendNonTranslating(node.getChars());
                break;
            }
            default: {
                markdown.append(node.getChars());
            }
        }
    }

    private void render(HtmlInlineComment node, NodeFormatterContext context, MarkdownWriter markdown) {
        BasedSequence text = (BasedSequence)((BasedSequence)node.getChars().trim()).midSequence(4, -3);
        if (!context.isTransformingText() && this.formatterOptions.linkMarkerCommentPattern != null && this.formatterOptions.linkMarkerCommentPattern.matcher(text).matches()) {
            ((MarkdownWriter)((MarkdownWriter)markdown.append("<!--")).append(String.valueOf(text.toMapped(SpaceMapper.toNonBreakSpace)))).append("-->");
        } else {
            markdown.appendTranslating("<!--", text, "-->");
        }
    }

    private void render(Reference node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference(node, context, markdown);
    }

    private void render(AutoLink node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderAutoLink(node, context, markdown, this.myTranslationAutolinkPrefix, null);
    }

    private void render(MailLink node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderAutoLink(node, context, markdown, this.myTranslationAutolinkPrefix, null);
    }

    private void renderAutoLink(DelimitedLinkNode node, NodeFormatterContext context, MarkdownWriter markdown, String prefix, String suffix) {
        if (context.isTransformingText()) {
            switch (context.getRenderPurpose()) {
                case TRANSLATION_SPANS: {
                    if (node.getOpeningMarker().isNull()) {
                        this.myTranslationStore.set(UNWRAPPED_AUTO_LINKS, Boolean.valueOf(true));
                        context.postProcessNonTranslating(s2 -> {
                            UNWRAPPED_AUTO_LINKS_MAP.get(this.myTranslationStore).add((String)s2);
                            return s2;
                        }, () -> {
                            markdown.append("<");
                            markdown.appendNonTranslating(prefix, node.getText(), suffix);
                            markdown.append(">");
                        });
                        break;
                    }
                    markdown.append("<");
                    markdown.appendNonTranslating(prefix, node.getText(), suffix);
                    markdown.append(">");
                    break;
                }
                case TRANSLATED_SPANS: {
                    markdown.append("<");
                    markdown.appendNonTranslating(prefix, node.getText(), suffix);
                    markdown.append(">");
                    break;
                }
                case TRANSLATED: {
                    if (UNWRAPPED_AUTO_LINKS.get(this.myTranslationStore).booleanValue() && UNWRAPPED_AUTO_LINKS_MAP.get(this.myTranslationStore).contains(node.getText().toString())) {
                        markdown.appendNonTranslating(prefix, node.getText(), suffix);
                        break;
                    }
                    markdown.append("<");
                    markdown.appendNonTranslating(prefix, node.getText(), suffix);
                    markdown.append(">");
                    break;
                }
                default: {
                    markdown.append(node.getChars());
                    break;
                }
            }
        } else {
            markdown.append(node.getChars());
        }
    }

    private void render(Image node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!context.isTransformingText() && this.formatterOptions.rightMargin > 0 && this.formatterOptions.keepImageLinksAtStart) {
            markdown.append('\u2028');
        } else {
            markdown.lineIf(this.formatterOptions.keepImageLinksAtStart);
        }
        if (!this.formatterOptions.optimizedInlineRendering || context.isTransformingText()) {
            markdown.append(node.getTextOpeningMarker());
            if (!context.isTransformingText() || node.getFirstChildAny(HtmlInline.class) != null) {
                if (this.formatterOptions.rightMargin > 0) {
                    markdown.append((CharSequence)node.getText().toMapped(SpaceMapper.toNonBreakSpace));
                } else {
                    context.renderChildren(node);
                }
            } else {
                markdown.appendTranslating(node.getText());
            }
            markdown.append(node.getTextClosingMarker());
            markdown.append(node.getLinkOpeningMarker());
            markdown.append(node.getUrlOpeningMarker());
            if (context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS) {
                ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl(), false);
                markdown.appendNonTranslating(resolvedLink.getPageRef());
            } else {
                markdown.append(node.getUrlOpeningMarker());
                markdown.appendNonTranslating(node.getPageRef());
            }
            markdown.append(node.getUrlClosingMarker());
            if (!node.getUrlContent().isEmpty()) {
                markdown.openPreFormatted(true);
                ((MarkdownWriter)markdown.pushOptions()).preserveSpaces();
                if (!context.isTransformingText() && this.formatterOptions.rightMargin > 0) {
                    BasedSequence chars = node.getUrlContent();
                    int iMax = chars.length();
                    boolean hadEOL = true;
                    markdown.append('\n');
                    block4: for (int i = 0; i < iMax; ++i) {
                        char c = chars.charAt(i);
                        switch (c) {
                            case '\n': 
                            case '\r': {
                                hadEOL = true;
                                markdown.append(chars.subSequence(i, i + 1));
                                continue block4;
                            }
                            case ' ': {
                                if (hadEOL) {
                                    markdown.append('\u2028');
                                    hadEOL = false;
                                }
                                markdown.append('\u00a0');
                                continue block4;
                            }
                            default: {
                                if (hadEOL) {
                                    markdown.append('\u2028');
                                    hadEOL = false;
                                }
                                markdown.append(chars.subSequence(i, i + 1));
                            }
                        }
                    }
                } else {
                    markdown.append(node.getUrlContent());
                }
                markdown.popOptions();
                markdown.closePreFormatted();
                markdown.append('\u2028');
            }
            if (node.getTitleOpeningMarker().isNotNull()) {
                markdown.append(' ');
                markdown.append(node.getTitleOpeningMarker());
                if (node.getTitle().isNotNull()) {
                    markdown.appendTranslating(node.getTitle());
                }
                markdown.append(node.getTitleClosingMarker());
            }
            markdown.append(node.getLinkClosingMarker());
        } else {
            markdown.append(node.getChars());
        }
    }

    private void render(Link node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!context.isTransformingText() && this.formatterOptions.rightMargin > 0 && this.formatterOptions.keepExplicitLinksAtStart) {
            markdown.append('\u2028');
        } else {
            markdown.lineIf(this.formatterOptions.keepExplicitLinksAtStart);
        }
        if (!this.formatterOptions.optimizedInlineRendering || context.isTransformingText()) {
            markdown.append(node.getTextOpeningMarker());
            if (!context.isTransformingText() || node.getFirstChildAny(HtmlInline.class) != null) {
                if (this.formatterOptions.rightMargin > 0) {
                    markdown.append((CharSequence)node.getText().toMapped(SpaceMapper.toNonBreakSpace));
                } else {
                    context.renderChildren(node);
                }
            } else {
                markdown.appendTranslating(node.getText());
            }
            markdown.append(node.getTextClosingMarker());
            markdown.append(node.getLinkOpeningMarker());
            markdown.append(node.getUrlOpeningMarker());
            if (context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS) {
                ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl(), false);
                markdown.appendNonTranslating(resolvedLink.getPageRef());
                if (resolvedLink.getAnchorRef() != null) {
                    markdown.append("#");
                    CharSequence anchorRef = context.transformAnchorRef(resolvedLink.getPageRef(), resolvedLink.getAnchorRef());
                    markdown.append(anchorRef);
                }
            } else {
                CharSequence pageRef = context.transformNonTranslating(null, node.getPageRef(), null, null);
                markdown.append(pageRef);
                markdown.append(node.getAnchorMarker());
                if (node.getAnchorRef().isNotNull()) {
                    CharSequence anchorRef = context.transformAnchorRef(node.getPageRef(), node.getAnchorRef());
                    if (this.attributeUniquificationIdMap != null && context.getRenderPurpose() == RenderPurpose.TRANSLATED && context.getMergeContext() != null) {
                        String uniquifiedAnchorRef = String.valueOf(anchorRef);
                        if (pageRef.length() == 0) {
                            uniquifiedAnchorRef = this.attributeUniquificationIdMap.getOrDefault(uniquifiedAnchorRef, uniquifiedAnchorRef);
                        }
                        markdown.append(uniquifiedAnchorRef);
                    } else {
                        markdown.append(anchorRef);
                    }
                }
            }
            markdown.append(node.getUrlClosingMarker());
            if (node.getTitleOpeningMarker().isNotNull()) {
                markdown.append(' ');
                markdown.append(node.getTitleOpeningMarker());
                if (node.getTitle().isNotNull()) {
                    markdown.appendTranslating(node.getTitle());
                }
                markdown.append(node.getTitleClosingMarker());
            }
            markdown.append(node.getLinkClosingMarker());
        } else {
            markdown.append(node.getChars());
        }
    }

    private void render(ImageRef node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!this.formatterOptions.optimizedInlineRendering || context.isTransformingText()) {
            if (context.isTransformingText() || this.formatterOptions.rightMargin == 0) {
                if (node.isReferenceTextCombined()) {
                    markdown.append(node.getReferenceOpeningMarker());
                    markdown.appendTranslating(node.getReference());
                    markdown.append(node.getReferenceClosingMarker());
                    markdown.append(node.getTextOpeningMarker());
                    markdown.append(node.getTextClosingMarker());
                } else {
                    markdown.append(node.getTextOpeningMarker());
                    this.appendReference(node.getText(), context, markdown);
                    markdown.append(node.getTextClosingMarker());
                    markdown.append(node.getReferenceOpeningMarker());
                    markdown.appendTranslating(node.getReference());
                    markdown.append(node.getReferenceClosingMarker());
                }
            } else if (node.isReferenceTextCombined()) {
                markdown.append(node.getReferenceOpeningMarker());
                if (node.isOrDescendantOfType(Paragraph.class)) {
                    markdown.append((CharSequence)node.getReference().toMapped(SpaceMapper.toNonBreakSpace));
                } else {
                    markdown.append(node.getReference());
                }
                markdown.append(node.getReferenceClosingMarker());
                markdown.append(node.getTextOpeningMarker());
                markdown.append(node.getTextClosingMarker());
            } else {
                markdown.append(node.getTextOpeningMarker());
                context.renderChildren(node);
                markdown.append(node.getTextClosingMarker());
                markdown.append(node.getReferenceOpeningMarker());
                markdown.append(node.getReference());
                markdown.append(node.getReferenceClosingMarker());
            }
        } else {
            markdown.append(node.getChars());
        }
    }

    private void render(LinkRef node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!this.formatterOptions.optimizedInlineRendering || context.isTransformingText()) {
            if (context.isTransformingText() || this.formatterOptions.rightMargin == 0) {
                if (node.isReferenceTextCombined()) {
                    markdown.append(node.getReferenceOpeningMarker());
                    FormatterUtils.appendWhiteSpaceBetween(markdown, node.getReferenceOpeningMarker(), node.getReference(), true, false, false);
                    this.appendReference(node.getReference(), context, markdown);
                    markdown.append(node.getReferenceClosingMarker());
                    markdown.append(node.getTextOpeningMarker());
                    markdown.append(node.getTextClosingMarker());
                } else {
                    markdown.append(node.getTextOpeningMarker());
                    if (!context.isTransformingText() || node.getFirstChildAny(HtmlInline.class) != null) {
                        context.renderChildren(node);
                    } else {
                        this.appendReference(node.getText(), context, markdown);
                    }
                    markdown.append(node.getTextClosingMarker());
                    markdown.append(node.getReferenceOpeningMarker());
                    FormatterUtils.appendWhiteSpaceBetween(markdown, node.getReferenceOpeningMarker(), node.getReference(), true, false, false);
                    markdown.appendTranslating(node.getReference());
                    markdown.append(node.getReferenceClosingMarker());
                }
            } else if (node.isReferenceTextCombined()) {
                markdown.append(node.getReferenceOpeningMarker());
                if (node.isOrDescendantOfType(Paragraph.class)) {
                    markdown.append((CharSequence)node.getReference().toMapped(SpaceMapper.toNonBreakSpace));
                } else {
                    markdown.append(node.getReference());
                }
                markdown.append(node.getReferenceClosingMarker());
                markdown.append(node.getTextOpeningMarker());
                markdown.append(node.getTextClosingMarker());
            } else {
                markdown.append(node.getTextOpeningMarker());
                context.renderChildren(node);
                markdown.append(node.getTextClosingMarker());
                markdown.append(node.getReferenceOpeningMarker());
                markdown.append(node.getReference());
                markdown.append(node.getReferenceClosingMarker());
            }
        } else {
            markdown.append(node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new CoreNodeFormatter(options);
        }
    }
}

